<?php
require_once 'header.php';

$msg = "";
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $email = trim($_POST['email'] ?? '');
    if ($email && !filter_var($email,FILTER_VALIDATE_EMAIL)) {
        $msg = "بريد إلكتروني غير صالح";
    } else {
        $stmt = $mysqli->prepare("UPDATE safety_users SET email=? WHERE id=?");
        $stmt->bind_param("si",$email,$u['id']);
        $stmt->execute();
        $stmt->close();
        $_SESSION['user']['email'] = $email;
        $msg = "تم حفظ التعديلات";
    }
}
?>
<h5 class="mb-3">الملف الشخصي</h5>
<?php if ($msg): ?><div class="alert alert-success"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="post">
  <div class="mb-3">
    <label class="form-label">الاسم</label>
    <input type="text" class="form-control" value="<?= htmlspecialchars($u['full_name']) ?>" disabled>
  </div>
  <div class="mb-3">
    <label class="form-label">الرقم الوظيفي</label>
    <input type="text" class="form-control" value="<?= htmlspecialchars($u['employee_no']) ?>" disabled>
  </div>
  <div class="mb-3">
    <label class="form-label">البريد الإلكتروني</label>
    <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($u['email'] ?? '') ?>">
  </div>
  <button class="btn btn-primary">حفظ</button>
  <a href="dashboard.php" class="btn btn-secondary">رجوع</a>
</form>

<hr>
<a class="btn btn-outline-primary btn-sm" href="duty_correction.php">بلاغ تصحيح دوام</a>
<?php require 'footer.php'; ?>
