<?php
require_once 'header.php';

$is_admin = is_head_or_admin();
if ($is_admin) {
    $res = $mysqli->query("SELECT r.*, t.label_ar, u.full_name, u.employee_no
        FROM safety_reports r
        JOIN safety_report_types t ON t.id=r.report_type_id
        JOIN safety_users u ON u.id=r.user_id
        ORDER BY r.created_at DESC");
} else {
    $stmt = $mysqli->prepare("SELECT r.*, t.label_ar
        FROM safety_reports r
        JOIN safety_report_types t ON t.id=r.report_type_id
        WHERE r.user_id=? ORDER BY r.created_at DESC");
    $stmt->bind_param("i",$u['id']);
    $stmt->execute();
    $res = $stmt->get_result();
}
?>
<h5 class="mb-3">التقارير</h5>
<?php if (isset($_GET['ok'])): ?><div class="alert alert-success">تم حفظ التقرير.</div><?php endif; ?>
<div class="table-responsive">
<table class="table table-striped">
  <thead>
    <tr>
      <th>#</th><th>النوع</th><th>العنوان</th><th>التاريخ</th>
      <?php if ($is_admin): ?><th>الموظف</th><?php endif; ?>
      <th>تأخير (لليومي)</th>
    </tr>
  </thead>
  <tbody>
    <?php while($r = $res->fetch_assoc()): ?>
      <tr>
        <td><?= $r['id'] ?></td>
        <td><?= htmlspecialchars($r['label_ar']) ?></td>
        <td><?= htmlspecialchars($r['title']) ?></td>
        <td><?= htmlspecialchars($r['report_date']) ?></td>
        <?php if ($is_admin): ?>
          <td><?= htmlspecialchars(($r['full_name'] ?? '')." (".($r['employee_no'] ?? '').")") ?></td>
        <?php endif; ?>
        <td><?= $r['is_late'] ? 'نعم' : 'لا' ?></td>
      </tr>
    <?php endwhile; ?>
  </tbody>
</table>
</div>
<a href="dashboard.php" class="btn btn-secondary btn-sm">رجوع</a>
<?php require 'footer.php'; ?>
