<?php
require_once 'header.php';

$code = $_GET['type'] ?? '';
$stmt = $mysqli->prepare("SELECT * FROM safety_report_types WHERE code=? AND is_active=1");
$stmt->bind_param("s", $code);
$stmt->execute();
$type = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$type) {
    echo "<div class='alert alert-danger'>نوع التقرير غير موجود.</div>";
    require 'footer.php'; exit;
}

$msg = "";
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');
    $shift_name = trim($_POST['shift_name'] ?? '');
    $report_date = date('Y-m-d');

    if ($content === '') {
        $msg = "نص التقرير مطلوب";
    } else {
        $cutoff = strtotime($report_date.' 23:59:00');
        $is_late = ($type['is_daily'] && time() > $cutoff) ? 1 : 0;

        $ins = $mysqli->prepare("INSERT INTO safety_reports(user_id,report_type_id,title,content,shift_name,report_date,is_late) VALUES (?,?,?,?,?,?,?)");
        $ins->bind_param("iissssi",$u['id'],$type['id'],$title,$content,$shift_name,$report_date,$is_late);
        $ins->execute();
        $report_id = $ins->insert_id;
        $ins->close();

        if (!empty($_FILES['files']['name'][0])) {
            $uploadDir = __DIR__ . "/uploads/{$u['employee_no']}";
            if (!is_dir($uploadDir)) mkdir($uploadDir,0775,true);

            foreach ($_FILES['files']['name'] as $idx => $name) {
                if ($_FILES['files']['error'][$idx] === UPLOAD_ERR_OK) {
                    $tmp = $_FILES['files']['tmp_name'][$idx];
                    $safeName = time()."_".preg_replace("/[^a-zA-Z0-9\.\-_]/","_",$name);
                    $dest = $uploadDir . "/" . $safeName;
                    if (move_uploaded_file($tmp,$dest)) {
                        $rel = "uploads/{$u['employee_no']}/".$safeName;
                        $mime = $_FILES['files']['type'][$idx];
                        $stmt2 = $mysqli->prepare("INSERT INTO safety_report_files(report_id,file_name,file_path,mime_type) VALUES (?,?,?,?)");
                        $stmt2->bind_param("isss",$report_id,$name,$rel,$mime);
                        $stmt2->execute();
                        $stmt2->close();
                    }
                }
            }
        }

        header("Location: reports_list.php?ok=1");
        exit;
    }
}
?>
<h5 class="mb-3"><?= htmlspecialchars($type['label_ar']) ?></h5>
<?php if ($msg): ?><div class="alert alert-danger"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="post" enctype="multipart/form-data">
  <div class="mb-3">
    <label class="form-label">عنوان مختصر (اختياري)</label>
    <input type="text" name="title" class="form-control">
  </div>
  <div class="mb-3">
    <label class="form-label">نص التقرير</label>
    <textarea name="content" class="form-control" rows="6" required></textarea>
  </div>
  <div class="mb-3">
    <label class="form-label">الشفت (اختياري)</label>
    <input type="text" name="shift_name" class="form-control" placeholder="صباحي / مسائي / ليلي ...">
  </div>
  <div class="mb-3">
    <label class="form-label">مرفقات (PDF/صور)</label>
    <input type="file" name="files[]" class="form-control" multiple>
  </div>
  <button class="btn btn-primary">إرسال التقرير</button>
  <a href="dashboard.php" class="btn btn-secondary">رجوع</a>
</form>
<?php require 'footer.php'; ?>
