<?php
require_once 'config.php';

// شغّل هذا الملف مرة واحدة فقط ثم احذفه أو غيّر اسمه بعد الانتهاء.
// ينشئ الجداول + أنواع التقارير + مدير افتراضي A0001 / Admin@2552

$sql = "
CREATE TABLE IF NOT EXISTS safety_users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  full_name VARCHAR(120) NOT NULL,
  employee_no VARCHAR(50) NOT NULL UNIQUE,
  email VARCHAR(120) DEFAULT NULL,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('employee','head','admin') NOT NULL DEFAULT 'employee',
  is_active TINYINT(1) NOT NULL DEFAULT 1,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS safety_report_types (
  id INT AUTO_INCREMENT PRIMARY KEY,
  code VARCHAR(50) NOT NULL UNIQUE,
  label_ar VARCHAR(120) NOT NULL,
  is_daily TINYINT(1) NOT NULL DEFAULT 0,
  is_active TINYINT(1) NOT NULL DEFAULT 1
);

CREATE TABLE IF NOT EXISTS safety_reports (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  report_type_id INT NOT NULL,
  title VARCHAR(200) DEFAULT NULL,
  content LONGTEXT,
  shift_name VARCHAR(50) DEFAULT NULL,
  report_date DATE NOT NULL,
  is_late TINYINT(1) NOT NULL DEFAULT 0,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS safety_report_files (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  report_id BIGINT NOT NULL,
  file_name VARCHAR(200) NOT NULL,
  file_path VARCHAR(255) NOT NULL,
  mime_type VARCHAR(100) DEFAULT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE IF NOT EXISTS safety_schedule (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  duty_date DATE NOT NULL,
  status ENUM('مداوم','أوف','غياب') NOT NULL DEFAULT 'مداوم',
  shift_name VARCHAR(50) DEFAULT NULL,
  UNIQUE KEY uniq_user_date (user_id,duty_date)
);

CREATE TABLE IF NOT EXISTS safety_duty_corrections (
  id BIGINT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  duty_date DATE NOT NULL,
  claimed_status ENUM('مداوم','أوف','غياب') NOT NULL,
  notes LONGTEXT DEFAULT NULL,
  evidence_path VARCHAR(255) DEFAULT NULL,
  status ENUM('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
";

if ($mysqli->multi_query($sql)) {
    while ($mysqli->more_results() && $mysqli->next_result()) { /* flush */ }
}

// أنواع التقارير الأساسية
$types = [
  ['DAILY','التقرير اليومي',1],
  ['INCIDENT','تقرير حدث',0],
  ['LOST','تقرير مفقود',0],
  ['SAFETY_MAINT','تقرير سلامة (صيانة/أنظمة)',0],
  ['SAFETY_OCC','تقرير سلامة مهنية',0],
  ['SAFETY_ENV','تقرير سلامة بيئية',0],
];
$stmt = $mysqli->prepare("INSERT IGNORE INTO safety_report_types(code,label_ar,is_daily) VALUES (?,?,?)");
foreach ($types as $t) {
    $stmt->bind_param("ssi", $t[0], $t[1], $t[2]);
    $stmt->execute();
}
$stmt->close();

// مدير افتراضي
$admin_emp = "A0001";
$admin_pass = "Admin@2552";
$admin_name = "المدير العام";
$admin_email = "admin@example.com";

$check = $mysqli->prepare("SELECT id,full_name FROM safety_users WHERE employee_no=?");
$check->bind_param("s", $admin_emp);
$check->execute();
$check->store_result();
if ($check->num_rows == 0) {
    $hash = password_hash($admin_pass, PASSWORD_DEFAULT);
    $ins = $mysqli->prepare("INSERT INTO safety_users(full_name,employee_no,email,password_hash,role) VALUES (?,?,?,?, 'admin')");
    $ins->bind_param("ssss", $admin_name, $admin_emp, $admin_email, $hash);
    $ins->execute();
    $ins->close();
    $created_admin = true;
} else {
    $created_admin = false;
}
$check->close();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>تثبيت نظام الأمن والسلامة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="card p-4">
    <h3 class="mb-3">تم تنفيذ التثبيت</h3>
    <ul>
      <li>تم إنشاء الجداول الأساسية (المستخدمين، التقارير، الشفتات، التصحيحات).</li>
      <li>تم إضافة أنواع التقارير الرئيسية.</li>
      <li>
        <?php if ($created_admin): ?>
          تم إنشاء مستخدم مدير:<br>
          الرقم الوظيفي: <strong>A0001</strong><br>
          كلمة المرور: <strong>Admin@2552</strong>
        <?php else: ?>
          مستخدم المدير موجود مسبقًا (A0001).
        <?php endif; ?>
      </li>
    </ul>
    <p class="text-danger">يفضّل حذف ملف <code>install.php</code> بعد التأكد من عمل النظام.</p>
    <a class="btn btn-primary" href="login.php">الذهاب لصفحة الدخول</a>
  </div>
</div>
</body>
</html>
