<?php
require_once 'header.php';
if (!is_head_or_admin()) { echo "<div class='alert alert-danger'>مسموح لرئيس القسم أو المدير فقط.</div>"; require 'footer.php'; exit; }

$today = date('Y-m-d');

$sql = "
  SELECT u.id, u.full_name, u.employee_no,
    CASE WHEN EXISTS(
      SELECT 1 FROM safety_reports r
      JOIN safety_report_types t ON t.id=r.report_type_id
      WHERE r.user_id=u.id AND t.is_daily=1 AND r.report_date=?
    ) THEN 'مُدخل' ELSE 'غير مُدخل' END AS daily_status,
    COALESCE(SUM(
      CASE WHEN r.is_late=1 AND r.report_date=? AND t.is_daily=1 THEN 1 ELSE 0 END
    ),0) AS late_count
  FROM safety_users u
  LEFT JOIN safety_reports r ON r.user_id=u.id AND r.report_date=?
  LEFT JOIN safety_report_types t ON t.id=r.report_type_id
  GROUP BY u.id, u.full_name, u.employee_no
  ORDER BY u.employee_no
";
$stmt = $mysqli->prepare($sql);
$stmt->bind_param("sss",$today,$today,$today);
$stmt->execute();
$overview = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$sql2 = "
  SELECT u.full_name, u.employee_no, r.shift_name, COUNT(r.id) AS reports_count
  FROM safety_reports r
  JOIN safety_users u ON u.id=r.user_id
  WHERE r.report_date=?
  GROUP BY u.id, u.full_name, u.employee_no, r.shift_name
  ORDER BY u.employee_no
";
$stmt2 = $mysqli->prepare($sql2);
$stmt2->bind_param("s",$today);
$stmt2->execute();
$shifts = $stmt2->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt2->close();
?>
<h5 class="mb-3">متابعة التقارير اليومية - <?= $today ?></h5>
<h6>حالة إدخال التقرير اليومي</h6>
<div class="table-responsive mb-4">
<table class="table table-bordered">
  <thead><tr><th>الموظف</th><th>الرقم الوظيفي</th><th>حالة التقرير اليومي</th><th>عدد التقارير المتأخرة</th></tr></thead>
  <tbody>
    <?php foreach($overview as $r): ?>
      <tr>
        <td><?= htmlspecialchars($r['full_name']) ?></td>
        <td><?= htmlspecialchars($r['employee_no']) ?></td>
        <td><?= htmlspecialchars($r['daily_status']) ?></td>
        <td><?= (int)$r['late_count'] ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>

<h6>عدد التقارير لكل موظف حسب الشفت</h6>
<div class="table-responsive mb-3">
<table class="table table-bordered">
  <thead><tr><th>الموظف</th><th>الرقم الوظيفي</th><th>الشفت</th><th>عدد التقارير</th></tr></thead>
  <tbody>
    <?php foreach($shifts as $r): ?>
      <tr>
        <td><?= htmlspecialchars($r['full_name']) ?></td>
        <td><?= htmlspecialchars($r['employee_no']) ?></td>
        <td><?= htmlspecialchars($r['shift_name'] ?? '-') ?></td>
        <td><?= (int)$r['reports_count'] ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
<a href="dashboard.php" class="btn btn-secondary btn-sm">رجوع</a>
<?php require 'footer.php'; ?>
