<?php
require_once 'header.php';

$msg = "";
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $date = $_POST['duty_date'] ?? '';
    $claimed = $_POST['claimed_status'] ?? '';
    $notes = trim($_POST['notes'] ?? '');

    if (!$date || !in_array($claimed,['مداوم','أوف','غياب'])) {
        $msg = "يرجى تحديد تاريخ وحالة صحيحة";
    } else {
        $path = null;
        if (!empty($_FILES['evidence']['name']) && $_FILES['evidence']['error']==UPLOAD_ERR_OK) {
            $uploadDir = __DIR__ . "/uploads/evidence/{$u['employee_no']}";
            if (!is_dir($uploadDir)) mkdir($uploadDir,0775,true);
            $safeName = time()."_".preg_replace("/[^a-zA-Z0-9\.\-_]/","_",$_FILES['evidence']['name']);
            $dest = $uploadDir . "/" . $safeName;
            if (move_uploaded_file($_FILES['evidence']['tmp_name'],$dest)) {
                $path = "uploads/evidence/{$u['employee_no']}/".$safeName;
            }
        }

        $stmt = $mysqli->prepare("INSERT INTO safety_duty_corrections(user_id,duty_date,claimed_status,notes,evidence_path) VALUES (?,?,?,?,?)");
        $stmt->bind_param("issss",$u['id'],$date,$claimed,$notes,$path);
        $stmt->execute();
        $stmt->close();
        $msg = "تم إرسال البلاغ، سيتم مراجعتة من الإدارة.";
    }
}
?>
<h5 class="mb-3">بلاغ تصحيح دوام</h5>
<?php if ($msg): ?><div class="alert alert-info"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
<form method="post" enctype="multipart/form-data">
  <div class="mb-3">
    <label class="form-label">تاريخ الدوام</label>
    <input type="date" name="duty_date" class="form-control" required>
  </div>
  <div class="mb-3">
    <label class="form-label">الحالة الصحيحة</label>
    <select name="claimed_status" class="form-select" required>
      <option value="">اختر</option>
      <option value="مداوم">مداوم</option>
      <option value="أوف">أوف</option>
      <option value="غياب">غياب</option>
    </select>
  </div>
  <div class="mb-3">
    <label class="form-label">ملاحظات</label>
    <textarea name="notes" class="form-control" rows="4"></textarea>
  </div>
  <div class="mb-3">
    <label class="form-label">مرفق (اختياري)</label>
    <input type="file" name="evidence" class="form-control">
  </div>
  <button class="btn btn-primary">إرسال البلاغ</button>
  <a href="profile.php" class="btn btn-secondary">رجوع</a>
</form>
<?php require 'footer.php'; ?>
